* rt-bar.prg
* v1.0
*
* Forecast unemployment rate using real-time data

calendar 1951 1 12
allocate 2100:12

declare integer FIRSTOBS LASTOBS ESTEND ESTBEG FCBEG FCEND FCLEN

open data input.csv
data(format=cdf, org=col) / E U U_S HWI UIC
close data

** locate last observation for UR
set ur = U/(U+E)
inquire(series=ur) FIRSTOBS LASTOBS
set urdata = ur

*************************************************
*** PARAMETERS FOR ESTIMATION AND FORECASTING ***
*************************************************
compute NLAGS=2;                    * Number of lags in VAR
compute ESTEND=LASTOBS;             * End date for VAR estimation
compute ESTBEG=ESTEND-179;          * Start date for VAR estimation
compute FCLEN=24;                   * Forecast length
compute FCBEG=ESTEND+1;             * Starting date for UR forecast
compute FCEND=FCBEG+FCLEN;          * Last date for which forecasts are desired

****************************************
*** COMPUTE HAZARD RATES FROM STOCKS ***
****************************************
* adjust for redesign
set orig_U_s = U_s
set U_s * 1994:1 = orig_U_s
set U_s 1994:2 * = 1.1549*orig_U_s
*
set bigF = 1 - ((U{-1} - U_s{-1})/U)
set f = -log(1-bigF)
* set up s series
set s = %na
* iterate
do i = FIRSTOBS,LASTOBS-1
  compute Ei = E(i)
  compute Ui = U(i)
  compute U1i = U(i+1)
  compute fi = f(i)
  nonlin x
  * guess average s
  compute xs = 0.0345
  * transform xs in [0,1] to x in [-inf,inf]
  compute x = log(xs/(1-xs))
  compute value = 0.0
  find(method=genetic,iterations=100,subiterations=100000,cvcrit=0.0001,noprint) root value
    * x in [-inf,inf]; xs in [0,1]
    compute xs = exp(x)/(1+exp(x))
    compute value = U1i - (Ui+Ei)*xs*(1-exp(-fi-xs))/(fi+xs) - Ui*exp(-fi-xs)
  end find
  set s i i = xs
end do
*
*print(picture="#.#####") / s f ur

*************************************
*** UR FORECAST WITH CONSTANT S&F ***
*************************************
* hold s & f constant at last values
set s_bar = s
set f_bar = f
set s_bar FCBEG-1 FCEND = s(lastobs-1)
set f_bar FCBEG-1 FCEND = f(lastobs-1)
* steady state unemployment rate
set ssur_bar = s_bar/(s_bar+f_bar)
* convergence speed
set beta_bar = 1-exp(-f_bar-s_bar)
* iterate to create UR forecast
set ur_bar * lastobs = urdata
do t=FCBEG-1,FCEND
  set ur_bar t t = beta_bar(t)*ssur_bar(t-1) + (1-beta_bar(t))*ur_bar(t-1)
end do
set ur_bar * lastobs = urdata
*
print(picture="#.#####") FCBEG-2 FCEND s_bar f_bar ssur_bar ur_bar

********************************
*** STORE SERIES TO CSV FILE ***
********************************
open(noappend) copy output.csv
copy(format=cdf,dates,org=columns) / ur_bar
close copy
